<?php
/**
 * Dynamik Skin functions.
 */

/*** BEGIN CORE SKIN FUNCTIONS
	Below is code that is critical to both creating Dynamik and Exported Child Theme
	compatible constants as well as calling in your Skin's scripts.js file. So leave this
	code alone unless you absolutely know what you're doing and why you're editing it.
***/

// Define the Skin constants.
if ( CHILD_THEME_NAME != 'Dynamik Website Builder' ) {
	define( 'SKIN_DIR', get_stylesheet_directory() . '/lib' );
	define( 'SKIN_URL', get_stylesheet_directory_uri() . '/lib' );
} else {
	define( 'SKIN_DIR', dynamik_get_active_skin_folder_path() );
	define( 'SKIN_URL', dynamik_get_active_skin_folder_url() );
}

add_action( 'wp_enqueue_scripts', 'skin_register_scripts' );
/**
 * Register additional Skin scripts and styles.
 *
 * @since 1.0
 */
function skin_register_scripts() {
	/* Uncomment the line below (remove the two beginning forward slasses '//') to activate your {JS} file. */
	wp_register_script( 'skin-scripts', SKIN_URL . '/scripts.js', array( 'jquery' ), CHILD_THEME_VERSION, true );
}

add_action( 'wp_enqueue_scripts', 'skin_load_scripts' );
/**
 * Load additional Skin scripts and styles.
 *
 * @since 1.0
 */
function skin_load_scripts() {
	/* Uncomment the line below (remove the two beginning forward slasses '//') to activate your {JS} file. */
	wp_enqueue_script( 'skin-scripts' );
}

/*** END CORE SKIN FUNCTIONS
	Below you may include additional Skin functions.
***/

//end Dynamik Skin functions.php