/* PLEASE NOTE: To make this {JS} file active you must uncomment two lines of code in your Skin's {PHP} file. */

/*
 * Add regular (non-jQuery) Javascript code above.
 * Add jQuery code by placing it between the opening "{" bracket and closing "});" brackets below.
 */
jQuery(document).ready(function($) {

	/* Function that adds a 'fixed-header' body class when the browser/device width is greater than 1140px
	 * and removes the 'fixed-header' body class when it's 1140px or less. This "disables" the fixed design
	 * for smaller browser/devices sizes to allow for greater vertical space in such viewing situations.
	 * This is basically the JS version of CSS's @media query, for responsive design scenarios.
	 */
	$(window).resize(function() {
		if ($(this).width() > 1140) {
			$('body').addClass('fixed-header');
		} else {
			$('body').removeClass('fixed-header');
		}
	});

	/* Trigger the above .resize function to ensure the proper body class
	 * is in place based on the browser/device width.
	 */
	$(window).resize();

	/* Add/remove a 'scrolled' body class based on the scroll position of the web page
	 * to properly enable/disable the fixed elements at the appropriate time.
	 */
	$(function() {
	    $(window).scroll(function() {
			// Set the scroll position variable
	        var scroll = $(window).scrollTop();
			
			// Add or remove the 'scrolled' body class based on scroll position
	        if (scroll >= 150) {
				$('body').addClass('scrolled');
	        } else {
				$('body').removeClass('scrolled');
	        }
	    });
	});	

});